/*
    Copyright  2001 Christoph Brzozowski - All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*! @file CAbstractGrid.h
 *
 *  @brief
 *	Deklarationen der Klasse \b CAbstractGrid.
 *   
 *  @author Christoph Brzozowski.
 *  
 */

#ifndef cls_CAbstractGridH
#define cls_CAbstractGridH

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <stdlib.h>
#include <stdexcept>
using std::invalid_argument;

/*! 
 * @class CAbstractGrid
 *
 * @ingroup bsplineWarpClasses
 * 
 * \brief Abstrakte Basisklasse fr die Implementierung eines zweidimensionalen dynamischen Arrays.
 *
 *  Die Klasse \b CAbstractGrid definiert eine grundlegende Schnittstelle fr das
 *  abgeleitete Klassetemplate \b CGrid.
 *
 *  \remarks
 *  Template-Klassen, die mit unterschiedlichen Templateparametern instantiiert werden,
 *  sind grundstzlich typinkompatibel. Es ist jedoch manchmal erforderlich oder wnschenswert, ein 
 *  CGrid-Objekt zu bergeben, unabhngig davon welchen Typ die Elemente aufweisen. Hier greift
 *  diese abstrakte Basisklasse ein.
 *
 */

class CAbstractGrid 
{

protected:

  //! Speichert die Breite des Grids, d.h. die Anzahl der Spalten.
	int Width;				 
	//! Speichert die  Hhe des Grids, d.h. die Anzahl der Zeilen.
	int Height;			   
	//! Speichert einen Zeiger auf die Elementdaten.
	void* Elements;		 
	//! Speichert die Gre eines Gridelements in Bytes.
	int SizeOfElement; 

public:

	//! Standardkonstruktor.
	CAbstractGrid();

	//! Gibt zurck, ob das Grid ein NULL-Grid ist.
	bool isNull()
	{
		return ((Width==0) && (Height==0) && (Elements == NULL));
	};

	//! Gibt die Breite, also die Anzahl der Spalten des Grids zurck.
	int width()
	{
		return Width;
	};

	//! Gibt die Hhe, also die Anzahl der Zeilen des Grids zurck.
	int height()
	{
		return Height;
	};

	//! Gibt die Gre eines Gridelements in Bytes zurck.
	int getElementSize()
	{
		return SizeOfElement; 
	};

	//! Gibt den Zeiger auf den Speicherbereich, der die Elementdaten beinhaltet, zurck.
	const void* getElements()
	{
		return Elements;
	};

	//! Lscht den Inhalt des Grids.
	virtual void clear() = 0;
	//! ndert die Ausmae des Grids.
	virtual void resize(int intNewWidth, int intNewHeight) = 0;

	//! Standarddestruktor.
	virtual ~CAbstractGrid()
	{
	};
	
};

#endif

