
/*****************************************************************************\
 *                              AccumEffectPanel
\*****************************************************************************/

/*! @file AccumEffectPanel.h
 *
 *  @brief
 *  Die Benutzerschnittstelle zur Einstellung der Effektparameter.
 *   
 *  @author P.Claren & C.Mlhaupt
 *     
 */

/*! @class AccumEffectPanel
 *
 *  @ingroup accumClasses
 *	
 *  @brief Definitionen der benutzten Klassen und Methoden fr 
 *  @brief das Panel des AccumulationBuffer-Effektes.
 *
 **/
#ifndef ACCUMEFFECTPANEL_H
#define ACCUMEFFECTPANEL_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

// system library headers
#include <stdio.h>
#include <stdlib.h>

// Qt inculdes
#include <qobject.h>

#include <qvariant.h>
#include <qwidget.h>

//---------------------------------------------------------------------------
//  Forward references
//---------------------------------------------------------------------------

class QTimer;
class QLabel;
class QSlider;
class QLCDNumber;
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QButtonGroup;
class QComboBox;
class QDial;
class QGroupBox;
class QLCDNumber;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QSlider;
class QSpinBox;
class QTabWidget;
class QTimer;
class QFrame;

//**************************************************************************
// Accum Effect Panel
//**************************************************************************

class AccumEffectPanel: public QObject
{
	Q_OBJECT

//---------------------------------------------------------------------------
//  Public Instance Methods
//---------------------------------------------------------------------------
public:

// --------------------------------------------------------------------------
//! @name  Creation & Destruction
// @{
	
	//! Primary class contructor
	//AccumEffectPanel();
	
	//! class contructor mit bergabeparameter eines QWidget
	AccumEffectPanel(QWidget*);
	//! destructor
	~AccumEffectPanel();

	//! Liefert das EffektPanel.
	QFrame* getPanel();
	
// @} 

// --------------------------------------------------------------------------
//! @name Methoden um Parameter des Effektpanels auszulesen

// @{		  
	//! Bildsubtraktion: Wie viele Paare sollen accumuliert werden
	int getPaarAuswahl();
	
	//! Bildsubtraktion: Liefert den Anteil des 1. Bildes 1. Paares
	int getAnteilBild11();
	
	/** @brief Bildsubtraktion: Liefert die Nummer des Bildes
		relativ zum aktuellen Bild, welches akkumuliert werden soll
		des 1. Bildes 1. Paares */
	int getBildAuswahl11();
	
	//! Bildsubtraktion: Liefert den Anteil des 2. Bildes 1. Paares
	int getAnteilBild12();
	
	/** @brief Bildsubtraktion: Liefert die Nummer des Bildes relativ
		zum aktuellen Bild, welches akkumuliert werden soll 
		des  2. Bildes 1. Paares */
	int getBildAuswahl12();
	
	//! Bildsubtraktion: Liefert den Anteil des 1. Bildes 2. Paares
	int getAnteilBild21();
	
	/** @brief Bildsubtraktion: Liefert die Nummer des Bildes relativ 
		zum aktuellen Bild, welches akkumuliert werden soll 
		des  1. Bildes 2. Paares */
	int getBildAuswahl21();
	
	//! Bildsubtraktion: Liefert den Anteil des 2. Bildes 2. Paares
	int getAnteilBild22();
	
	/** @brief Bildsubtraktion: Liefert die Nummer des Bildes relativ 
		zum aktuellen Bild, welches akkumuliert werden soll des  
		2. Bildes 2. Paares */
	int getBildAuswahl22();
	
	//! Bildsubtraktion: Liefert den Anteil des 1. Bildes 3. Paares
	int getAnteilBild31();
	
	/** @brief Bildsubtraktion: Liefert die Nummer des Bildes relativ 
		zum aktuellen Bild, welches akkumuliert werden soll des  
		1. Bildes 3. Paares */
	int getBildAuswahl31();
	
	//! Bildsubtraktion: Liefert den Anteil des 2. Bildes 3. Paares
	int getAnteilBild32();
	
	/** @brief Bildsubtraktion: Liefert die Nummer des Bildes relativ
		zum aktuellen Bild, welches akkumuliert werden soll des  
		2. Bildes 3. Paares */
	int getBildAuswahl32();
	
	//! Bildsubtraktion: Liefert den Helligkeitsanteil des 1. Paares
	int getHellAnteil1();
	
	//! Bildsubtraktion: Liefert den Helligkeitsanteil des 2. Paares
	int getHellAnteil2();
	
	//! Bildsubtraktion: Liefert den Helligkeitsanteil des 3. Paares	
	int getHellAnteil3();
	
	//! Bildsubtraktion: Liefert den Operator des 1. Paares (+ / -)
	int getOp1();
	
	//! Bildsubtraktion: Liefert den Operator des 2. Paares (+ / -)
	int getOp2();
	
	//! Bildsubtraktion: Liefert den Operator des 3. Paares (+ / -)
	int getOp3();
	
	/** @brief Bildsubtraktion: Gibt Bool zurck, ob die jeweils ersten
		Bilder absolut in der Sequenz(true) oder relativ zum aktuellen
		(false) Bild gewhlt werden. */
	bool getFixFirst();
	
	//! Motion Blur: Liefert den Motion Blur-Faktor
	int getBlurFaktor();
	
	//! Motion Blur: Liefert die Nummer des gewhlten Effekt
	int getEffektAuswahl();
	
	//! Motion Blur: Liefert die Gammakorrektur
	int getGammaKorrektur();
	
	//! Motion Blur: Setzt alle Effektparameter auf ihre Anfangswerte zurck
	void ResetAll();
// @}

// --------------------------------------------------------------------------
//! @name private Slots

// @{		  
	
	private slots:
	void resetAnteil1();
	void resetAnteil2();
	void resetHellAnteil();
	void resetGamma();
	void PaarAuswahl(int);
	void setEnGamma();
	void setDisGamma();
	void switchOpButton1();
	void switchOpButton2();
	void switchOpButton3();
	void switchFixFirst();
	
// @}	

// --------------------------------------------------------------------------
// private Member variables
 
private:

	AccumEffectPanel& operator = (const AccumEffectPanel& source);

	QFrame* effectPanel;

	QTabWidget* UserInterfacePanel;
    QWidget* tab;
    QLabel* BS_LabelAnteil1;
    QLabel* BS_LabelBildNum1;
    QLabel* BS_LabelBildNum2;
    QLabel* BS_LabelPaarDoc;
    QSpinBox* BS_AnteilBild11;
    QSpinBox* BS_AnteilBild21;
    QSpinBox* BS_AnteilBild31;
    QLineEdit* BS_BildAuswahl11;
    QLineEdit* BS_BildAuswahl21;
    QLineEdit* BS_BildAuswahl31;
    QPushButton* BS_ButtonResetAnteilBilder1;
    QComboBox* BS_ComboBoxPaarAuswahl;
    QPushButton* BS_Minus1Label;
    QPushButton* BS_Minus2Label;
    QPushButton* BS_Minus3Label;
	QPushButton* BS_FixFirstButton;
    QLabel* BS_LabelAnteil2;
    QSpinBox* BS_AnteilBild12;
    QSpinBox* BS_AnteilBild22;
    QSpinBox* BS_AnteilBild32;
    QLineEdit* BS_BildAuswahl12;
    QLineEdit* BS_BildAuswahl22;
    QLineEdit* BS_BildAuswahl32;
    QPushButton* BS_ButtonResetAnteilBilder2;
    QLabel* BS_LabelHellAnteil;
    QSpinBox* BS_SpinBoxHellAnteil1;
    QSpinBox* BS_SpinBoxHellAnteil2;
    QSpinBox* BS_SpinBoxHellAnteil3;
    QPushButton* BS_ButtonResetHellAnteil;
    QSlider* BS_SliderHellAnteil3;
    QSlider* BS_SliderHellAnteil2;
    QSlider* BS_SliderHellAnteil1;
    QLabel* BS_HBildsubtraktion;
    QWidget* tab_2;
    QDial* MB_TachoDial;
    QLabel* MB_T0;
    QLabel* MB_T100;
    QLabel* MB_T50;
    QLCDNumber* MB_Tacho;
    QLabel* MB_HMotionBlur;
    QLabel* MB_Beschreibung;
	QWidget* tab_3;
    QGroupBox* HK_GammakorrekturGroup;
    QLabel* TextLabel2_4_3_2;
    QLabel* TextLabel2_4_4;
    QLabel* TextLabel2_4_2_2;
    QSpinBox* HK_GammaSpinBox;
    QSlider* HK_GammaSlider;
    QPushButton* HK_GammaResetButton;
    QButtonGroup* HK_EffektAuswahlGroup;
    QRadioButton* HK_BildSubRadio;
    QRadioButton* HK_MotBlurRadio;
    QRadioButton* HK_KeinEffRadio;
    QLabel* HK_HHauptkontrolle;

	int op1,op2,op3;
	bool stateFixFirst;
	
};

#endif
