
/*****************************************************************************\
 *                              Accum Effect Panel
\*****************************************************************************/

/*! @file AccumEffectPanel.cpp
 *
 *  @brief
 *	Die Steuerungseinheit der AccumEffekt-Klasse. Beinhaltet die Auswahl der Effekte
 *  und deren Parametersteuerung.
 * 
 *  @author 
 *  P.Claren & C.Mlhaupt
 *  
 */

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------


// Qt headers
#include <qgl.h>

#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qdial.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlcdnumber.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qwidget.h>
#include <qstring.h>

#include <qtimer.h>
#include <qvgroupbox.h>


// local headers
#include "AccumEffectPanel.h" 

/**
 * Gibt eine QFrame Zeiger auf das Effekt-Panel der AccumEffectPanel-Klasse zurck.
 **/
QFrame* AccumEffectPanel::getPanel() 
{
	return effectPanel;
}

/**
 * Bildsubtraktion
 * 
 * Liefert die Auswahl, wie viele Paare akkumuliert werden sollen
 **/
int AccumEffectPanel::getPaarAuswahl()
{
	return BS_ComboBoxPaarAuswahl->currentItem();
}

/**
 * Bildsubtraktion
 * 
 * Gibt den prozentualen Anteil 'erstes Paar/erstes Bild' zurck
 **/
int AccumEffectPanel::getAnteilBild11()
{
	return BS_AnteilBild11->value();
}

/**
 * Bildsubtraktion
 *
 * Gibt die relative position des ersten Bildes des ersten Paares zurck
 **/
int AccumEffectPanel::getBildAuswahl11()
{
	return atoi(BS_BildAuswahl11->text());
}

/**
 * Bildsubtraktion
 *
 * Gibt den prozentualen Anteil 'erstes Paar/zweites Bild' zurck
 **/
int AccumEffectPanel::getAnteilBild12()
{
	return BS_AnteilBild12->value();
}

/**
 * Bildsubtraktion
 *
 * Gibt die relative position des zweiten Bildes des ersten Paares zurck
 **/
int AccumEffectPanel::getBildAuswahl12()
{
	return atoi(BS_BildAuswahl12->text());
}

/**
 * Bildsubtraktion
 *
 * Gibt den prozentualen Anteil 'zweites Paar/erstes Bild' zurck
 **/
int AccumEffectPanel::getAnteilBild21()
{
	return BS_AnteilBild21->value();
}

/**
 * Bildsubtraktion 
 *
 * Gibt die relative position des ersten Bildes des zweiten Paares zurck
 **/
int AccumEffectPanel::getBildAuswahl21()
{
	return atoi(BS_BildAuswahl21->text());
}

/**
 * Bildsubtraktion
 *
 * Gibt den prozentualen Anteil 'zweites Paar/zweites Bild' zurck
 **/
int AccumEffectPanel::getAnteilBild22()
{
	return BS_AnteilBild22->value();
}

/**
 * Bildsubtraktion
 *
 * Gibt die relative position des zweiten Bildes des zweiten Paares zurck
 **/
int AccumEffectPanel::getBildAuswahl22()
{
	return atoi(BS_BildAuswahl22->text());
}

/**
 * Bildsubtraktion *
 *
 * Gibt den prozentualen Anteil 'drittes Paar/erstes Bild' zurck
 **/
int AccumEffectPanel::getAnteilBild31()
{
	return BS_AnteilBild31->value();
}

/**
 * Bildsubtraktion *
 *
 * Gibt die relative position des ersten Bildes des dritten Paares zurck
 **/
int AccumEffectPanel::getBildAuswahl31()
{
	return atoi(BS_BildAuswahl31->text());
}

/**
 * Bildsubtraktion
 *
 * Gibt den prozentualen Anteil 'drittes Paar/zweites Bild' zurck
 **/
int AccumEffectPanel::getAnteilBild32()
{
	return BS_AnteilBild32->value();
}

/**
 * Bildsubtraktion
 *
 * Gibt die relative position des zweiten Bildes des dritten Paares zurck
 **/
int AccumEffectPanel::getBildAuswahl32()
{
	return atoi(BS_BildAuswahl32->text());
}

/**
 * Bildsubtraktion
 *
 * Gibt den prozentualen Helligkeitsanteil des ersten Paares zurck
 **/
int AccumEffectPanel::getHellAnteil1()
{
	return BS_SpinBoxHellAnteil1->value();
}

/**
 * Bildsubtraktion
 *
 * Gibt den prozentualen Helligkeitsanteil des zweiten Paares zurck
 **/
int AccumEffectPanel::getHellAnteil2()
{
	return BS_SpinBoxHellAnteil2->value();
}

/**
 * Bildsubtraktion
 *
 * Gibt den prozentualen Helligkeitsanteil des dritten Paares zurck
 **/
int AccumEffectPanel::getHellAnteil3()
{
	return BS_SpinBoxHellAnteil3->value();
}


/**
 * Motion Blur
 *
 * Gibt den Blurfaktor zurck
 **/
int AccumEffectPanel::getBlurFaktor()
{
	return MB_TachoDial->value();
}

/**
 * Bildsubtraktion
 *
 * behandelt den Operationsknopf (+/-) des ersten Paares
 **/
void AccumEffectPanel::switchOpButton1()
{
	op1 *= -1;
	if ( op1 == -1) 
		BS_Minus1Label->setProperty( "text", tr( "-" ) );
	if ( op1 == +1) 
		BS_Minus1Label->setProperty( "text", tr( "+" ) );
}

/**
 * Bildsubtraktion
 *
 * behandelt den Operationsknopf (+/-) des zweiten Paares
 **/
void AccumEffectPanel::switchOpButton2()
{
	op1 *= -1;
	if ( op1 == -1) 
		BS_Minus2Label->setProperty( "text", tr( "-" ) );
	if ( op1 == +1) 
		BS_Minus2Label->setProperty( "text", tr( "+" ) );
}

/**
 * Bildsubtraktion
 *
 * behandelt den Operationsknopf (+/-) des zweiten Paares
 **/
void AccumEffectPanel::switchOpButton3()
{
	op1 *= -1;
	if ( op1 == -1) 
		BS_Minus3Label->setProperty( "text", tr( "-" ) );
	if ( op1 == +1) 
		BS_Minus3Label->setProperty( "text", tr( "+" ) );
}

/**
 * Bildsubtraktion
 *
 * gibt Boolean zurck, ob die ersten Bilder der Bildsubtraktion relativ zum ersten 
 * Bild oder zum aktuellen Bild gesehen werden
 **/
bool AccumEffectPanel::getFixFirst()
{
	return stateFixFirst;
}

/**
 * Bildsubtraktion
 *
 * ndert den Zustand, ob die ersten Bilder der Bildsubtraktion relativ zum ersten
 * Bild oder zum aktuellen Bild gesehen werden
 **/
void AccumEffectPanel::switchFixFirst()
{
	stateFixFirst = !stateFixFirst;
	if ( stateFixFirst )
		BS_FixFirstButton->setProperty( "text", tr( "Fixiere erste Bilder: an" ) );
	if ( !stateFixFirst )
		BS_FixFirstButton->setProperty( "text", tr( "Fixiere erste Bilder: aus" ) );
}



/**
 * Bildsubtraktion
 *
 * liefert den Operator (+/-) des ersten Bildpaares in Form von +1 / -1
 **/
int AccumEffectPanel::getOp1()
{
	return op1;
}

/**
 * Bildsubtraktion
 *
 * liefert den Operator (+/-) des zweiten Bildpaares in Form von +1 / -1
 **/
int AccumEffectPanel::getOp2()
{
	return op2;
}

/**
 * Bildsubtraktion
 *
 * liefert den Operator (+/-) des zweiten Bildpaares in Form von +1 / -1
 **/
int AccumEffectPanel::getOp3()
{
	return op3;
}


/**
 * Bildsubtraktion
 *
 * Gibt den ausgewhlten Effekt wieder. 0 Kein Effekt, 1 Motion Blur, 2 Bildsubtraktion
 **/
int AccumEffectPanel::getEffektAuswahl()
{
	int i=0;

	if(HK_BildSubRadio->isChecked())
		i=2;

	if(HK_MotBlurRadio->isChecked())
		i=1;

	return i;
}

/**
 * Bildsubtraktion
 *
 * gibt den Wert der Gammakorrektur zurck
 **/
int AccumEffectPanel::getGammaKorrektur()
{
	return HK_GammaSlider->value();
}

/**
 * Bildsubtraktion
 *
 * Setzt die Bildanteile der ersten Bilder der einzelnen Paare zurck auf die Anfangswerte.
 **/
void AccumEffectPanel::resetAnteil1()
{
    BS_AnteilBild11->setValue(100);
    BS_AnteilBild21->setValue(100);
    BS_AnteilBild31->setValue(100);
}

/**
 * Bildsubtraktion
 *
 * Setzt die Bildanteile der zweiten Bilder der einzelnen Paare zurck auf die Anfangswerte.
 **/
void AccumEffectPanel::resetAnteil2()
{
    BS_AnteilBild12->setValue(100);
    BS_AnteilBild22->setValue(100);
    BS_AnteilBild32->setValue(100);
}

/**
 * Bildsubtraktion
 *
 * Setzt die Helligkeitsanteile der Paare zurck auf die Anfangswerte.
 **/
void AccumEffectPanel::resetHellAnteil()
{
	int i = BS_ComboBoxPaarAuswahl->currentItem();
	if(i==0)
		{
			BS_SliderHellAnteil1->setValue(100);
			BS_SpinBoxHellAnteil1->setValue(100);
			BS_SliderHellAnteil2->setValue(1);
			BS_SpinBoxHellAnteil2->setValue(1);
			BS_SliderHellAnteil3->setValue(1);
			BS_SpinBoxHellAnteil3->setValue(1);
		}

	if(i==1)
		{
			BS_SliderHellAnteil1->setValue(50);
			BS_SpinBoxHellAnteil1->setValue(50);
			BS_SliderHellAnteil2->setValue(50);
			BS_SpinBoxHellAnteil2->setValue(50);
			BS_SliderHellAnteil3->setValue(1);
			BS_SpinBoxHellAnteil3->setValue(1);
		}

	if(i==2)
		{
			BS_SliderHellAnteil1->setValue(33);
			BS_SpinBoxHellAnteil1->setValue(33);
			BS_SliderHellAnteil2->setValue(33);
			BS_SpinBoxHellAnteil2->setValue(33);
			BS_SliderHellAnteil3->setValue(33);
			BS_SpinBoxHellAnteil3->setValue(33);
		}
}

/**
 * Hauptkontrolle
 *
 * Setzt den Wert der Gammakorrektur zurck auf 100%
 **/
void AccumEffectPanel::resetGamma()
{
    HK_GammaSpinBox->setValue(100);
    HK_GammaSlider->setValue(100);    
}

/**
 * Bildsubtraktion
 *
 * Macht einzelne Felder des Panels verfgbar oder sperrt diese in Abhngikeit davon
 * wie viele Paare akkumuliert werden sollen.
 **/
void AccumEffectPanel::PaarAuswahl(int i)
{
	if(i==0)
		{
			BS_AnteilBild21->setEnabled(false);
			BS_AnteilBild22->setEnabled(false);
			BS_AnteilBild31->setEnabled(false);
			BS_AnteilBild32->setEnabled(false);
			BS_BildAuswahl21->setEnabled(false);
			BS_BildAuswahl22->setEnabled(false);
			BS_BildAuswahl31->setEnabled(false);
			BS_BildAuswahl32->setEnabled(false);
			BS_SliderHellAnteil2->setEnabled(false);
			BS_SliderHellAnteil3->setEnabled(false);
			BS_SpinBoxHellAnteil2->setEnabled(false);
			BS_SpinBoxHellAnteil3->setEnabled(false);
			BS_SliderHellAnteil1->setValue(100);
			BS_SpinBoxHellAnteil1->setValue(100);
			BS_SliderHellAnteil2->setValue(1);
			BS_SpinBoxHellAnteil2->setValue(1);
			BS_SliderHellAnteil3->setValue(1);
			BS_SpinBoxHellAnteil3->setValue(1);
		}

	if(i==1)
		{
			BS_AnteilBild21->setEnabled(true);
			BS_AnteilBild22->setEnabled(true);
			BS_AnteilBild31->setEnabled(false);
			BS_AnteilBild32->setEnabled(false);
			BS_BildAuswahl21->setEnabled(true);
			BS_BildAuswahl22->setEnabled(true);
			BS_BildAuswahl31->setEnabled(false);
			BS_BildAuswahl32->setEnabled(false);
			BS_SliderHellAnteil2->setEnabled(true);
			BS_SliderHellAnteil3->setEnabled(false);
			BS_SpinBoxHellAnteil2->setEnabled(true);
			BS_SpinBoxHellAnteil3->setEnabled(false);
			BS_SliderHellAnteil1->setValue(50);
			BS_SpinBoxHellAnteil1->setValue(50);
			BS_SliderHellAnteil2->setValue(50);
			BS_SpinBoxHellAnteil2->setValue(50);
			BS_SliderHellAnteil3->setValue(1);
			BS_SpinBoxHellAnteil3->setValue(1);
		}

	if(i==2)
		{
			BS_AnteilBild21->setEnabled(true);
			BS_AnteilBild22->setEnabled(true);
			BS_AnteilBild31->setEnabled(true);
			BS_AnteilBild32->setEnabled(true);
			BS_BildAuswahl21->setEnabled(true);
			BS_BildAuswahl22->setEnabled(true);
			BS_BildAuswahl31->setEnabled(true);
			BS_BildAuswahl32->setEnabled(true);
			BS_SliderHellAnteil2->setEnabled(true);
			BS_SliderHellAnteil3->setEnabled(true);
			BS_SpinBoxHellAnteil2->setEnabled(true);
			BS_SpinBoxHellAnteil3->setEnabled(true);
			BS_SliderHellAnteil1->setValue(33);
			BS_SpinBoxHellAnteil1->setValue(33);
			BS_SliderHellAnteil2->setValue(33);
			BS_SpinBoxHellAnteil2->setValue(33);
			BS_SliderHellAnteil3->setValue(33);
			BS_SpinBoxHellAnteil3->setValue(33);
		}
}

/**
 * Hauptkontrolle
 *
 * aktiviert die Gammakorrekturbedienelemente
 **/
void AccumEffectPanel::setEnGamma()
{
	HK_GammaSpinBox->setEnabled(true);
	HK_GammaResetButton->setEnabled(true);
	HK_GammaSlider->setEnabled(true);
}

/**
 * Hauptkontrolle
 *
 * deaktiviert die Gammakorrekturbedienelemente
 **/
void AccumEffectPanel::setDisGamma()
{
	HK_GammaSpinBox->setEnabled(false);
	HK_GammaResetButton->setEnabled(false);
	HK_GammaSlider->setEnabled(false);
}

/**
 * Destruktor
 *
 * Lscht alle Objecte, fr die innerhalb von AccumEffectPanel 
 * Speicherplatz reserviert wurde
 * 
 **/
AccumEffectPanel::~AccumEffectPanel()	
{
	delete UserInterfacePanel;
	delete effectPanel;	
    delete tab;
    delete BS_LabelAnteil1;
    delete BS_LabelBildNum1;
    delete BS_LabelBildNum2;
    delete BS_LabelPaarDoc;
    delete BS_AnteilBild11;
    delete BS_AnteilBild21;
    delete BS_AnteilBild31;
    delete BS_BildAuswahl11;
    delete BS_BildAuswahl21;
    delete BS_BildAuswahl31;
    delete BS_ButtonResetAnteilBilder1;
    delete BS_ComboBoxPaarAuswahl;
    delete BS_Minus1Label;
    delete BS_Minus2Label;
    delete BS_Minus3Label;
	delete BS_FixFirstButton;
    delete BS_LabelAnteil2;
    delete BS_AnteilBild12;
    delete BS_AnteilBild22;
    delete BS_AnteilBild32;
    delete BS_BildAuswahl12;
    delete BS_BildAuswahl22;
    delete BS_BildAuswahl32;
    delete BS_ButtonResetAnteilBilder2;
    delete BS_LabelHellAnteil;
    delete BS_SpinBoxHellAnteil1;
    delete BS_SpinBoxHellAnteil2;
    delete BS_SpinBoxHellAnteil3;
    delete BS_ButtonResetHellAnteil;
    delete BS_SliderHellAnteil3;
    delete BS_SliderHellAnteil2;
    delete BS_SliderHellAnteil1;
    delete BS_HBildsubtraktion;
    delete tab_2;
    delete MB_TachoDial;
    delete MB_T0;
    delete MB_T100;
    delete MB_T50;
    delete MB_Tacho;
    delete MB_HMotionBlur;
    delete tab_3;
    delete HK_GammakorrekturGroup;
    delete TextLabel2_4_3_2;
    delete TextLabel2_4_4;
    delete TextLabel2_4_2_2;
    delete HK_GammaSpinBox;
    delete HK_GammaSlider;
    delete HK_GammaResetButton;
    delete HK_EffektAuswahlGroup;
    delete HK_BildSubRadio;
    delete HK_MotBlurRadio;
    delete HK_KeinEffRadio;
    delete HK_HHauptkontrolle;
}


/**
 * Konstruktor
 *
 * Konstruiert den Dialog des Effekpanels mit allen Bedienelementen und setzt diese
 * ihre Anfangswerte.
 * 
 **/
AccumEffectPanel::AccumEffectPanel(QWidget* parent)
	:	QObject(parent)
{
	op1=op2=op3=-1;
	stateFixFirst=false;
	
	effectPanel = new QGroupBox("Accumulation Buffer",parent,"user");
	effectPanel->setGeometry(0,0,440,240);

	UserInterfacePanel = new QTabWidget( effectPanel, "UserInterfacePanel" );
    UserInterfacePanel->setGeometry( QRect( 0, 0, 440, 240 ) ); 
    
	QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 223, 223, 223) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 211, 211, 211) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
    cg.setColor( QColorGroup::HighlightedText, white );
   
	pal.setActive( cg );
    
	cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 211, 211, 211) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
    cg.setColor( QColorGroup::HighlightedText, white );
    
	pal.setInactive( cg );
    
	cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 211, 211, 211) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
    cg.setColor( QColorGroup::HighlightedText, white );
    
	pal.setDisabled( cg );
    
	UserInterfacePanel->setProperty( "palette", pal );

    tab = new QWidget( UserInterfacePanel, "tab" );

    BS_LabelAnteil1 = new QLabel( tab, "BS_LabelAnteil1" );
    BS_LabelAnteil1->setGeometry( QRect( 120, 50, 40, 21 ) ); 
    BS_LabelAnteil1->setProperty( "text", tr( "Anteil" ) );

    BS_LabelBildNum1 = new QLabel( tab, "BS_LabelBildNum1" );
    BS_LabelBildNum1->setGeometry( QRect( 160, 50, 30, 21 ) ); 
    BS_LabelBildNum1->setProperty( "text", tr( "Bild#" ) );

    BS_LabelBildNum2 = new QLabel( tab, "BS_LabelBildNum2" );
    BS_LabelBildNum2->setGeometry( QRect( 270, 50, 30, 21 ) ); 
    BS_LabelBildNum2->setProperty( "text", tr( "Bild#" ) );

    BS_LabelPaarDoc = new QLabel( tab, "BS_LabelPaarDoc" );
    BS_LabelPaarDoc->setGeometry( QRect( 20, 80, 90, 51 ) ); 
    BS_LabelPaarDoc->setProperty( "text", tr( "Wie viele Paare \nsollen Accumuliert \nwerden?" ) );

    BS_AnteilBild11 = new QSpinBox( tab, "BS_AnteilBild11" );
    BS_AnteilBild11->setGeometry( QRect( 110, 70, 50, 21 ) ); 
    BS_AnteilBild11->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_AnteilBild11->setProperty( "prefix", tr( "" ) );
    BS_AnteilBild11->setProperty( "suffix", tr( "%" ) );
    BS_AnteilBild11->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_AnteilBild11->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_AnteilBild11->setProperty( "maxValue", 100 );
    BS_AnteilBild11->setProperty( "minValue", 1 );
    BS_AnteilBild11->setProperty( "value", 100 );

    BS_AnteilBild21 = new QSpinBox( tab, "BS_AnteilBild21" );
    BS_AnteilBild21->setGeometry( QRect( 110, 100, 50, 21 ) ); 
    BS_AnteilBild21->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_AnteilBild21->setProperty( "prefix", tr( "" ) );
    BS_AnteilBild21->setProperty( "suffix", tr( "%" ) );
    BS_AnteilBild21->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_AnteilBild21->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_AnteilBild21->setProperty( "maxValue", 100 );
    BS_AnteilBild21->setProperty( "minValue", 1 );
    BS_AnteilBild21->setProperty( "value", 100 );

    BS_AnteilBild31 = new QSpinBox( tab, "BS_AnteilBild31" );
    BS_AnteilBild31->setGeometry( QRect( 110, 130, 50, 21 ) ); 
    BS_AnteilBild31->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_AnteilBild31->setProperty( "prefix", tr( "" ) );
    BS_AnteilBild31->setProperty( "suffix", tr( "%" ) );
    BS_AnteilBild31->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_AnteilBild31->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_AnteilBild31->setProperty( "maxValue", 100 );
    BS_AnteilBild31->setProperty( "minValue", 1 );
    BS_AnteilBild31->setProperty( "value", 100 );

    BS_BildAuswahl11 = new QLineEdit( tab, "BS_BildAuswahl11" );
    BS_BildAuswahl11->setGeometry( QRect( 160, 70, 31, 22 ) ); 
    BS_BildAuswahl11->setProperty( "text", tr( "0" ) );

    BS_BildAuswahl21 = new QLineEdit( tab, "BS_BildAuswahl21" );
    BS_BildAuswahl21->setProperty( "enabled", QVariant( TRUE, 0 ) );
    BS_BildAuswahl21->setGeometry( QRect( 160, 100, 31, 22 ) ); 
    BS_BildAuswahl21->setProperty( "text", tr( "2" ) );
    BS_BildAuswahl21->setProperty( "edited", QVariant( FALSE, 0 ) );

    BS_BildAuswahl31 = new QLineEdit( tab, "BS_BildAuswahl31" );
    BS_BildAuswahl31->setProperty( "enabled", QVariant( TRUE, 0 ) );
    BS_BildAuswahl31->setGeometry( QRect( 160, 130, 31, 22 ) ); 
    BS_BildAuswahl31->setProperty( "text", tr( "4" ) );

    BS_ButtonResetAnteilBilder1 = new QPushButton( tab, "BS_ButtonResetAnteilBilder1" );
    BS_ButtonResetAnteilBilder1->setGeometry( QRect( 110, 160, 40, 21 ) ); 
    QFont BS_ButtonResetAnteilBilder1_font(  BS_ButtonResetAnteilBilder1->font() );
    BS_ButtonResetAnteilBilder1->setFont( BS_ButtonResetAnteilBilder1_font ); 
    BS_ButtonResetAnteilBilder1->setProperty( "text", tr( "reset" ) );

    BS_ComboBoxPaarAuswahl = new QComboBox( FALSE, tab, "BS_ComboBoxPaarAuswahl" );
    BS_ComboBoxPaarAuswahl->insertItem( tr( "Ein Paar" ) );
    BS_ComboBoxPaarAuswahl->insertItem( tr( "Zwei Paare" ) );
    BS_ComboBoxPaarAuswahl->insertItem( tr( "Drei Paare" ) );
    BS_ComboBoxPaarAuswahl->setGeometry( QRect( 20, 130, 91, 20 ) ); 

    BS_Minus1Label = new QPushButton( tab, "BS_Minus1Label" );
    BS_Minus1Label->setGeometry( QRect( 200, 70, 16, 21 ) ); 
    QFont BS_Minus1Label_font(  BS_Minus1Label->font() );
    BS_Minus1Label_font.setPointSize( 20 );
    BS_Minus1Label_font.setBold( TRUE );
    BS_Minus1Label->setFont( BS_Minus1Label_font ); 
    BS_Minus1Label->setProperty( "text", tr( "-" ) );

    BS_Minus2Label = new QPushButton( tab, "BS_Minus2Label" );
    BS_Minus2Label->setGeometry( QRect( 200, 100, 16, 21 ) ); 
    QFont BS_Minus2Label_font(  BS_Minus2Label->font() );
    BS_Minus2Label_font.setPointSize( 20 );
    BS_Minus2Label_font.setBold( TRUE );
    BS_Minus2Label->setFont( BS_Minus2Label_font ); 
    BS_Minus2Label->setProperty( "text", tr( "-" ) );

    BS_Minus3Label = new QPushButton( tab, "BS_Minus3Label" );
    BS_Minus3Label->setGeometry( QRect( 200, 130, 16, 21 ) ); 
    QFont BS_Minus3Label_font(  BS_Minus3Label->font() );
    BS_Minus3Label_font.setPointSize( 20 );
    BS_Minus3Label_font.setBold( TRUE );
    BS_Minus3Label->setFont( BS_Minus3Label_font ); 
    BS_Minus3Label->setProperty( "text", tr( "-" ) );

    BS_FixFirstButton = new QPushButton( tab, "BS_FixFirst" );
    BS_FixFirstButton->setGeometry( QRect( 100, 35, 130, 18 ) ); 
    QFont BS_FixFirstButton_font(  BS_FixFirstButton->font() );
    BS_FixFirstButton_font.setPointSize( 6 );
    BS_FixFirstButton->setFont( BS_FixFirstButton_font ); 
    BS_FixFirstButton->setProperty( "text", tr( "Fixiere erste Bilder: aus" ) );

	BS_LabelAnteil2 = new QLabel( tab, "BS_LabelAnteil2" );
    BS_LabelAnteil2->setGeometry( QRect( 230, 50, 40, 21 ) ); 
    BS_LabelAnteil2->setProperty( "text", tr( "Anteil" ) );

    BS_AnteilBild12 = new QSpinBox( tab, "BS_AnteilBild12" );
    BS_AnteilBild12->setGeometry( QRect( 220, 70, 50, 21 ) ); 
    BS_AnteilBild12->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_AnteilBild12->setProperty( "prefix", tr( "" ) );
    BS_AnteilBild12->setProperty( "suffix", tr( "%" ) );
    BS_AnteilBild12->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_AnteilBild12->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_AnteilBild12->setProperty( "maxValue", 100 );
    BS_AnteilBild12->setProperty( "minValue", 1 );
    BS_AnteilBild12->setProperty( "value", 100 );

    BS_AnteilBild22 = new QSpinBox( tab, "BS_AnteilBild22" );
    BS_AnteilBild22->setGeometry( QRect( 220, 100, 50, 21 ) ); 
    BS_AnteilBild22->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_AnteilBild22->setProperty( "prefix", tr( "" ) );
    BS_AnteilBild22->setProperty( "suffix", tr( "%" ) );
    BS_AnteilBild22->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_AnteilBild22->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_AnteilBild22->setProperty( "maxValue", 100 );
    BS_AnteilBild22->setProperty( "minValue", 1 );
    BS_AnteilBild22->setProperty( "value", 100 );

    BS_AnteilBild32 = new QSpinBox( tab, "BS_AnteilBild32" );
    BS_AnteilBild32->setGeometry( QRect( 220, 130, 50, 21 ) ); 
    BS_AnteilBild32->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_AnteilBild32->setProperty( "prefix", tr( "" ) );
    BS_AnteilBild32->setProperty( "suffix", tr( "%" ) );
    BS_AnteilBild32->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_AnteilBild32->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_AnteilBild32->setProperty( "maxValue", 100 );
    BS_AnteilBild32->setProperty( "minValue", 1 );
    BS_AnteilBild32->setProperty( "value", 100 );

    BS_BildAuswahl12 = new QLineEdit( tab, "BS_BildAuswahl12" );
    BS_BildAuswahl12->setGeometry( QRect( 270, 70, 31, 22 ) ); 
    BS_BildAuswahl12->setProperty( "text", tr( "1" ) );

    BS_BildAuswahl22 = new QLineEdit( tab, "BS_BildAuswahl22" );
    BS_BildAuswahl22->setProperty( "enabled", QVariant( TRUE, 0 ) );
    BS_BildAuswahl22->setGeometry( QRect( 270, 100, 31, 22 ) ); 
    BS_BildAuswahl22->setProperty( "text", tr( "3" ) );

    BS_BildAuswahl32 = new QLineEdit( tab, "BS_BildAuswahl32" );
    BS_BildAuswahl32->setProperty( "enabled", QVariant( TRUE, 0 ) );
    BS_BildAuswahl32->setGeometry( QRect( 270, 130, 31, 22 ) ); 
    BS_BildAuswahl32->setProperty( "text", tr( "5" ) );

    BS_ButtonResetAnteilBilder2 = new QPushButton( tab, "BS_ButtonResetAnteilBilder2" );
    BS_ButtonResetAnteilBilder2->setGeometry( QRect( 220, 160, 40, 21 ) ); 
    QFont BS_ButtonResetAnteilBilder2_font(  BS_ButtonResetAnteilBilder2->font() );
    BS_ButtonResetAnteilBilder2->setFont( BS_ButtonResetAnteilBilder2_font ); 
    BS_ButtonResetAnteilBilder2->setProperty( "text", tr( "reset" ) );

    BS_LabelHellAnteil = new QLabel( tab, "BS_LabelHellAnteil" );
    BS_LabelHellAnteil->setGeometry( QRect( 320, 50, 91, 21 ) ); 
    BS_LabelHellAnteil->setProperty( "text", tr( "Helligkeitsanteil" ) );

    BS_SpinBoxHellAnteil1 = new QSpinBox( tab, "BS_SpinBoxHellAnteil1" );
    BS_SpinBoxHellAnteil1->setGeometry( QRect( 380, 70, 50, 21 ) ); 
    BS_SpinBoxHellAnteil1->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_SpinBoxHellAnteil1->setProperty( "prefix", tr( "" ) );
    BS_SpinBoxHellAnteil1->setProperty( "suffix", tr( "%" ) );
    BS_SpinBoxHellAnteil1->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_SpinBoxHellAnteil1->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_SpinBoxHellAnteil1->setProperty( "maxValue", 100 );
    BS_SpinBoxHellAnteil1->setProperty( "minValue", 1 );
    BS_SpinBoxHellAnteil1->setProperty( "value", 33 );

    BS_SpinBoxHellAnteil2 = new QSpinBox( tab, "BS_SpinBoxHellAnteil2" );
    BS_SpinBoxHellAnteil2->setGeometry( QRect( 380, 100, 50, 21 ) ); 
    BS_SpinBoxHellAnteil2->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_SpinBoxHellAnteil2->setProperty( "prefix", tr( "" ) );
    BS_SpinBoxHellAnteil2->setProperty( "suffix", tr( "%" ) );
    BS_SpinBoxHellAnteil2->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_SpinBoxHellAnteil2->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_SpinBoxHellAnteil2->setProperty( "maxValue", 100 );
    BS_SpinBoxHellAnteil2->setProperty( "minValue", 1 );
    BS_SpinBoxHellAnteil2->setProperty( "value", 33 );

    BS_SpinBoxHellAnteil3 = new QSpinBox( tab, "BS_SpinBoxHellAnteil3" );
    BS_SpinBoxHellAnteil3->setGeometry( QRect( 380, 130, 50, 21 ) ); 
    BS_SpinBoxHellAnteil3->setProperty( "frameShadow", (int)QSpinBox::Sunken );
    BS_SpinBoxHellAnteil3->setProperty( "prefix", tr( "" ) );
    BS_SpinBoxHellAnteil3->setProperty( "suffix", tr( "%" ) );
    BS_SpinBoxHellAnteil3->setProperty( "wrapping", QVariant( FALSE, 0 ) );
    BS_SpinBoxHellAnteil3->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    BS_SpinBoxHellAnteil3->setProperty( "maxValue", 100 );
    BS_SpinBoxHellAnteil3->setProperty( "minValue", 1 );
    BS_SpinBoxHellAnteil3->setProperty( "value", 33 );

    BS_ButtonResetHellAnteil = new QPushButton( tab, "BS_ButtonResetHellAnteil" );
    BS_ButtonResetHellAnteil->setGeometry( QRect( 380, 160, 40, 21 ) ); 
    QFont BS_ButtonResetHellAnteil_font(  BS_ButtonResetHellAnteil->font() );
    BS_ButtonResetHellAnteil->setFont( BS_ButtonResetHellAnteil_font ); 
    BS_ButtonResetHellAnteil->setProperty( "text", tr( "reset" ) );

    BS_SliderHellAnteil3 = new QSlider( tab, "BS_SliderHellAnteil3" );
    BS_SliderHellAnteil3->setProperty( "enabled", QVariant( TRUE, 0 ) );
    BS_SliderHellAnteil3->setGeometry( QRect( 310, 130, 60, 20 ) ); 
    BS_SliderHellAnteil3->setProperty( "maxValue", 100 );
    BS_SliderHellAnteil3->setProperty( "value", 33 );
    BS_SliderHellAnteil3->setProperty( "orientation", (int)QSlider::Horizontal );

    BS_SliderHellAnteil2 = new QSlider( tab, "BS_SliderHellAnteil2" );
    BS_SliderHellAnteil2->setProperty( "enabled", QVariant( TRUE, 0 ) );
    BS_SliderHellAnteil2->setGeometry( QRect( 310, 100, 60, 20 ) ); 
    BS_SliderHellAnteil2->setProperty( "maxValue", 100 );
    BS_SliderHellAnteil2->setProperty( "value", 33 );
    BS_SliderHellAnteil2->setProperty( "orientation", (int)QSlider::Horizontal );

    BS_SliderHellAnteil1 = new QSlider( tab, "BS_SliderHellAnteil1" );
    BS_SliderHellAnteil1->setGeometry( QRect( 310, 70, 60, 20 ) ); 
    BS_SliderHellAnteil1->setProperty( "maxValue", 100 );
    BS_SliderHellAnteil1->setProperty( "value", 33 );
    BS_SliderHellAnteil1->setProperty( "orientation", (int)QSlider::Horizontal );

    BS_HBildsubtraktion = new QLabel( tab, "BS_HBildsubtraktion" );
    BS_HBildsubtraktion->setGeometry( QRect( 10, 10, 160, 21 ) ); 
    QFont BS_HBildsubtraktion_font(  BS_HBildsubtraktion->font() );
    BS_HBildsubtraktion_font.setFamily( "Arial" );
    BS_HBildsubtraktion_font.setPointSize( 16 );
    BS_HBildsubtraktion_font.setBold( TRUE );
    BS_HBildsubtraktion->setFont( BS_HBildsubtraktion_font ); 
    BS_HBildsubtraktion->setProperty( "text", tr( "Bildsubtraktion" ) );
    UserInterfacePanel->insertTab( tab, tr( "Bildsubtraktion" ) );

    tab_2 = new QWidget( UserInterfacePanel, "tab_2" );

	MB_Beschreibung= new QLabel( tab_2, "MB_Beschreibung" );
    MB_Beschreibung->setGeometry( QRect( 10, 70, 160, 60 ) ); 
    QFont MB_Beschreibung_font(  MB_Beschreibung->font() );
    MB_Beschreibung_font.setFamily( "Arial" );
    MB_Beschreibung_font.setPointSize( 10 );
    MB_Beschreibung->setFont( MB_Beschreibung_font ); 
    MB_Beschreibung->setProperty( "text", tr( "AltesBild * Faktor +\nNeuesBild * (1 - Faktor)" ) );
    
	MB_TachoDial = new QDial( tab_2, "MB_TachoDial" );
    MB_TachoDial->setGeometry( QRect( 180, 40, 150, 151 ) ); 
    MB_TachoDial->setProperty( "cursor", QCursor( 0 ) );
    MB_TachoDial->setProperty( "focusPolicy", (int)QDial::NoFocus );
    MB_TachoDial->setProperty( "notchesVisible", QVariant( TRUE, 0 ) );
    MB_TachoDial->setProperty( "maxValue", 100 );
    MB_TachoDial->setProperty( "value", 50 );

    MB_T0 = new QLabel( tab_2, "MB_T0" );
    MB_T0->setGeometry( QRect( 200, 170, 16, 41 ) ); 
    QFont MB_T0_font(  MB_T0->font() );
    MB_T0_font.setFamily( "Arial" );
    MB_T0_font.setPointSize( 12 );
    MB_T0_font.setBold( TRUE );
    MB_T0->setFont( MB_T0_font ); 
    MB_T0->setProperty( "text", tr( "0" ) );

    MB_T100 = new QLabel( tab_2, "MB_T100" );
    MB_T100->setGeometry( QRect( 300, 170, 30, 41 ) ); 
    QFont MB_T100_font(  MB_T100->font() );
    MB_T100_font.setFamily( "Arial" );
    MB_T100_font.setPointSize( 12 );
    MB_T100_font.setBold( TRUE );
    MB_T100->setFont( MB_T100_font ); 
    MB_T100->setProperty( "text", tr( "100" ) );

    MB_T50 = new QLabel( tab_2, "MB_T50" );
    MB_T50->setGeometry( QRect( 250, 20, 20, 20 ) ); 
    QFont MB_T50_font(  MB_T50->font() );
    MB_T50_font.setFamily( "Arial" );
    MB_T50_font.setPointSize( 12 );
    MB_T50_font.setBold( TRUE );
    MB_T50->setFont( MB_T50_font ); 
    MB_T50->setProperty( "text", tr( "50" ) );

    MB_Tacho = new QLCDNumber( tab_2, "MB_Tacho" );
    MB_Tacho->setGeometry( QRect( 240, 150, 30, 20 ) ); 

    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 223, 223, 223) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, white );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
    cg.setColor( QColorGroup::HighlightedText, white );
   
	pal.setActive( cg );
    
	cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, white );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
    cg.setColor( QColorGroup::HighlightedText, white );
    
	pal.setInactive( cg );
    
	cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, white );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
    cg.setColor( QColorGroup::HighlightedText, white );
    
	pal.setDisabled( cg );
    
	MB_Tacho->setProperty( "palette", pal );
    MB_Tacho->setProperty( "frameShape", (int)QLCDNumber::WinPanel );
    MB_Tacho->setProperty( "frameShadow", (int)QLCDNumber::Sunken );
    MB_Tacho->setProperty( "numDigits", 3 );
    MB_Tacho->setProperty( "intValue", 50 );

    MB_HMotionBlur = new QLabel( tab_2, "MB_HMotionBlur" );
    MB_HMotionBlur->setGeometry( QRect( 10, 10, 160, 21 ) ); 
    QFont MB_HMotionBlur_font(  MB_HMotionBlur->font() );
    MB_HMotionBlur_font.setFamily( "Arial" );
    MB_HMotionBlur_font.setPointSize( 16 );
    MB_HMotionBlur_font.setBold( TRUE );
    MB_HMotionBlur->setFont( MB_HMotionBlur_font ); 
    MB_HMotionBlur->setProperty( "text", tr( "Motion Blur" ) );
    UserInterfacePanel->insertTab( tab_2, tr( "Motion Blur" ) );

    tab_3 = new QWidget( UserInterfacePanel, "tab_3" );

    HK_GammakorrekturGroup = new QGroupBox( tab_3, "HK_GammakorrekturGroup" );
    HK_GammakorrekturGroup->setGeometry( QRect( 150, 40, 280, 90 ) ); 
    HK_GammakorrekturGroup->setProperty( "title", tr( "Gammakorrektur" ) );

    TextLabel2_4_3_2 = new QLabel( HK_GammakorrekturGroup, "TextLabel2_4_3_2" );
    TextLabel2_4_3_2->setGeometry( QRect( 70, 39, 30, 21 ) ); 
    TextLabel2_4_3_2->setProperty( "text", tr( "100%" ) );

    TextLabel2_4_4 = new QLabel( HK_GammakorrekturGroup, "TextLabel2_4_4" );
    TextLabel2_4_4->setGeometry( QRect( 220, 39, 30, 21 ) ); 
    TextLabel2_4_4->setProperty( "text", tr( "400%" ) );

    TextLabel2_4_2_2 = new QLabel( HK_GammakorrekturGroup, "TextLabel2_4_2_2" );
    TextLabel2_4_2_2->setGeometry( QRect( 30, 39, 30, 21 ) ); 
    TextLabel2_4_2_2->setProperty( "text", tr( "1%" ) );

    HK_GammaSpinBox = new QSpinBox( HK_GammakorrekturGroup, "HK_GammaSpinBox" );
    HK_GammaSpinBox->setGeometry( QRect( 50, 20, 71, 20 ) ); 
    HK_GammaSpinBox->setProperty( "suffix", tr( "%" ) );
    HK_GammaSpinBox->setProperty( "buttonSymbols", (int)QSpinBox::PlusMinus );
    HK_GammaSpinBox->setProperty( "maxValue", 400 );
    HK_GammaSpinBox->setProperty( "minValue", 1 );
    HK_GammaSpinBox->setProperty( "value", 100 );

    HK_GammaSlider = new QSlider( HK_GammakorrekturGroup, "HK_GammaSlider" );
    HK_GammaSlider->setGeometry( QRect( 30, 60, 210, 20 ) ); 
    HK_GammaSlider->setProperty( "backgroundOrigin", (int)QSlider::WidgetOrigin );
    HK_GammaSlider->setProperty( "minValue", 1 );
    HK_GammaSlider->setProperty( "maxValue", 400 );
    HK_GammaSlider->setProperty( "value", 100 );
    HK_GammaSlider->setProperty( "tracking", QVariant( TRUE, 0 ) );
    HK_GammaSlider->setProperty( "orientation", (int)QSlider::Horizontal );

    HK_GammaResetButton = new QPushButton( HK_GammakorrekturGroup, "HK_GammaResetButton" );
    HK_GammaResetButton->setGeometry( QRect( 130, 20, 40, 21 ) ); 
    QFont HK_GammaResetButton_font(  HK_GammaResetButton->font() );
    HK_GammaResetButton->setFont( HK_GammaResetButton_font ); 
    HK_GammaResetButton->setProperty( "text", tr( "reset" ) );

    HK_EffektAuswahlGroup = new QButtonGroup( tab_3, "HK_EffektAuswahlGroup" );
    HK_EffektAuswahlGroup->setGeometry( QRect( 30, 40, 110, 90 ) ); 
    HK_EffektAuswahlGroup->setProperty( "title", tr( "Effekt Auswahl" ) );

    HK_BildSubRadio = new QRadioButton( HK_EffektAuswahlGroup, "HK_BildSubRadio" );
    HK_BildSubRadio->setGeometry( QRect( 10, 20, 89, 17 ) ); 
    HK_BildSubRadio->setProperty( "text", tr( "Bildsubtraktion" ) );
    HK_BildSubRadio->setProperty( "autoResize", QVariant( TRUE, 0 ) );
    HK_BildSubRadio->setProperty( "checked", QVariant( FALSE, 0 ) );

    HK_MotBlurRadio = new QRadioButton( HK_EffektAuswahlGroup, "HK_MotBlurRadio" );
    HK_MotBlurRadio->setGeometry( QRect( 10, 40, 73, 17 ) ); 
    HK_MotBlurRadio->setProperty( "text", tr( "Motion Blur" ) );
    HK_MotBlurRadio->setProperty( "autoResize", QVariant( TRUE, 0 ) );
    HK_MotBlurRadio->setProperty( "checked", QVariant( FALSE, 0 ) );

    HK_KeinEffRadio = new QRadioButton( HK_EffektAuswahlGroup, "HK_KeinEffRadio" );
    HK_KeinEffRadio->setGeometry( QRect( 10, 60, 71, 17 ) ); 
    HK_KeinEffRadio->setProperty( "text", tr( "kein Effekt" ) );
    HK_KeinEffRadio->setProperty( "autoResize", QVariant( TRUE, 0 ) );
    HK_KeinEffRadio->setProperty( "checked", QVariant( TRUE, 0 ) );

    HK_HHauptkontrolle = new QLabel( tab_3, "HK_HHauptkontrolle" );
    HK_HHauptkontrolle->setGeometry( QRect( 10, 10, 160, 21 ) ); 
    QFont HK_HHauptkontrolle_font(  HK_HHauptkontrolle->font() );
    HK_HHauptkontrolle_font.setFamily( "Arial" );
    HK_HHauptkontrolle_font.setPointSize( 16 );
    HK_HHauptkontrolle_font.setBold( TRUE );
    HK_HHauptkontrolle->setFont( HK_HHauptkontrolle_font ); 
    HK_HHauptkontrolle->setProperty( "text", tr( "Hauptkontrolle" ) );
    UserInterfacePanel->insertTab( tab_3, tr( "Hauptkontrolle" ) );

	BS_AnteilBild21->setEnabled(false);
	BS_AnteilBild22->setEnabled(false);
	BS_AnteilBild31->setEnabled(false);
	BS_AnteilBild32->setEnabled(false);
	BS_BildAuswahl21->setEnabled(false);
	BS_BildAuswahl22->setEnabled(false);
	BS_BildAuswahl31->setEnabled(false);
	BS_BildAuswahl32->setEnabled(false);
	BS_SliderHellAnteil2->setEnabled(false);
	BS_SliderHellAnteil3->setEnabled(false);
	BS_SpinBoxHellAnteil2->setEnabled(false);
	BS_SpinBoxHellAnteil3->setEnabled(false);
	BS_SliderHellAnteil1->setValue(100);
	BS_SpinBoxHellAnteil1->setValue(100);
	BS_SliderHellAnteil2->setValue(1);
	BS_SpinBoxHellAnteil2->setValue(1);
	BS_SliderHellAnteil3->setValue(1);
	BS_SpinBoxHellAnteil3->setValue(1);

	UserInterfacePanel->showPage(tab_3);
	
	// signals and slots connections
    connect( MB_TachoDial, SIGNAL( valueChanged(int) ), MB_Tacho, SLOT( display(int) ) );
    connect( BS_SliderHellAnteil1, SIGNAL( valueChanged(int) ), BS_SpinBoxHellAnteil1, SLOT( setValue(int) ) );
    connect( BS_SpinBoxHellAnteil1, SIGNAL( valueChanged(int) ), BS_SliderHellAnteil1, SLOT( setValue(int) ) );
    connect( BS_SliderHellAnteil2, SIGNAL( valueChanged(int) ), BS_SpinBoxHellAnteil2, SLOT( setValue(int) ) );
    connect( BS_SpinBoxHellAnteil2, SIGNAL( valueChanged(int) ), BS_SliderHellAnteil2, SLOT( setValue(int) ) );
    connect( BS_SliderHellAnteil3, SIGNAL( valueChanged(int) ), BS_SpinBoxHellAnteil3, SLOT( setValue(int) ) );
    connect( BS_SpinBoxHellAnteil3, SIGNAL( valueChanged(int) ), BS_SliderHellAnteil3, SLOT( setValue(int) ) );
    connect( HK_GammaSlider, SIGNAL( valueChanged(int) ), HK_GammaSpinBox, SLOT( setValue(int) ) );
    connect( HK_GammaSpinBox, SIGNAL( valueChanged(int) ), HK_GammaSlider, SLOT( setValue(int) ) );

	connect( BS_ButtonResetAnteilBilder1, SIGNAL( clicked() ),  SLOT( resetAnteil1() ) );
	connect( BS_ButtonResetAnteilBilder2, SIGNAL( clicked() ),  SLOT( resetAnteil2() ) );
	connect( BS_ButtonResetHellAnteil, SIGNAL( clicked() ),  SLOT( resetHellAnteil() ) );

	connect( BS_Minus1Label, SIGNAL( clicked() ),  SLOT( switchOpButton1() ) );
	connect( BS_Minus2Label, SIGNAL( clicked() ),  SLOT( switchOpButton2() ) );
	connect( BS_Minus3Label, SIGNAL( clicked() ),  SLOT( switchOpButton3() ) );
	
	connect( BS_FixFirstButton, SIGNAL( clicked() ),  SLOT( switchFixFirst() ) );

	connect( HK_GammaResetButton, SIGNAL( clicked() ),  SLOT( resetGamma() ) );

	connect( BS_ComboBoxPaarAuswahl, SIGNAL( activated(int) ),  SLOT( PaarAuswahl(int) ) );
	
	connect( HK_KeinEffRadio, SIGNAL( clicked() ), SLOT( setDisGamma()) );
	connect( HK_MotBlurRadio, SIGNAL( clicked() ), SLOT( setEnGamma() ) );
	connect( HK_BildSubRadio, SIGNAL( clicked() ), SLOT( setEnGamma() ) );
	
	setDisGamma();
}
	
/**
 * Setzt alle Parameter auf die Anfangswerte zurck
 **/
void AccumEffectPanel::ResetAll()
{
	op1=op2=op3=-1;
	stateFixFirst=false;
	
	
    UserInterfacePanel->setGeometry( QRect( 0, 0, 440, 240 ) ); 
    
	BS_AnteilBild11->setValue( 100 );
	BS_AnteilBild21->setValue( 100 );
	BS_AnteilBild31->setValue( 100 );
	BS_AnteilBild12->setValue( 100 );
	BS_AnteilBild22->setValue( 100 );
    BS_AnteilBild32->setValue( 100 );
	
    BS_BildAuswahl11->setProperty( "text", tr( "0" ) );
    BS_BildAuswahl21->setProperty( "text", tr( "2" ) );
    BS_BildAuswahl31->setProperty( "text", tr( "4" ) );
    BS_BildAuswahl12->setProperty( "text", tr( "1" ) );
    BS_BildAuswahl22->setProperty( "text", tr( "3" ) );
    BS_BildAuswahl32->setProperty( "text", tr( "5" ) );

    BS_FixFirstButton->setProperty( "text", tr( "Fixiere erste Bilder: aus" ) );

    BS_SpinBoxHellAnteil1->setValue( 33 );
	BS_SpinBoxHellAnteil2->setValue( 33 );
	BS_SpinBoxHellAnteil3->setValue( 33 );

    BS_SliderHellAnteil1->setValue( 100 );
	BS_SliderHellAnteil2->setValue( 1 );
	BS_SliderHellAnteil3->setValue( 1 );
	
	BS_AnteilBild21->setEnabled( false );
	BS_AnteilBild22->setEnabled( false );
	BS_AnteilBild31->setEnabled( false );
	BS_AnteilBild32->setEnabled( false );
	BS_BildAuswahl21->setEnabled( false );
	BS_BildAuswahl22->setEnabled( false );
	BS_BildAuswahl31->setEnabled( false );
	BS_BildAuswahl32->setEnabled( false );
	BS_SliderHellAnteil2->setEnabled( false );
	BS_SliderHellAnteil3->setEnabled( false );
	BS_SpinBoxHellAnteil2->setEnabled( false );
	BS_SpinBoxHellAnteil3->setEnabled( false );
    
	BS_ComboBoxPaarAuswahl->setCurrentItem( 0 );

	MB_TachoDial->setValue( 50 );
	MB_Tacho->display( 50 );

    HK_GammaSpinBox->setValue( 100 );
    HK_GammaSlider->setValue( 100 );
    
    HK_BildSubRadio->setChecked( false );
    HK_MotBlurRadio->setChecked( false );
    HK_KeinEffRadio->setChecked( true );

	BS_Minus1Label->setProperty( "text", tr( "-" ) );
	BS_Minus2Label->setProperty( "text", tr( "-" ) );
	BS_Minus3Label->setProperty( "text", tr( "-" ) );
}
