
/*****************************************************************************\
 *                              Accum Effect
\*****************************************************************************/

/**
 * @defgroup accumClasses Image subtraction / motion blur effect classes
 * 
 *
 */

/*! @file AccumEffect.h
 *
 *  @brief
 *	Accumulation Effect Class
 *   
 *  @author P.Claren & C.Mlhaupt
 *     
 */

/*! @class AccumEffect
 *
 * @ingroup accumClasses
 *
 * @brief 
 * AccumEffekt benutzt den AccumulationBuffer der OpenGL fr Effekte auf Filmsequenzen.
 *   
 **/

#ifndef ACCUMEFFECT_H
#define ACCUMEFFECT_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

// system library headers
#include <stdio.h>
#include <stdlib.h>

#include <qvariant.h>
#include <qwidget.h>



// Local headers

// GLEffect.h must ALWAYS be included!
#include "../main/GLEffect.h" 

// forward class declarations

class AccumEffectPanel;

//**************************************************************************
// Accum Effect
//**************************************************************************

class AccumEffect: public GLEffect
{
	Q_OBJECT

//---------------------------------------------------------------------------
//  Public Instance Methods
//---------------------------------------------------------------------------
public:

// --------------------------------------------------------------------------
//! @name  Creation, desctruction
// @{
	
	//! Primary class contructor
	AccumEffect(GLFramework* parent);
	
	//! Destructor
	virtual ~AccumEffect();

	void createControls(QWidget* parentWindow);
	
	
// --------------------------------------------------------------------------
// @} 

//! @name Public API functions
// @{


	//! Creates control widgets that will manipulate effect parameters & behaviour. 


// --------------------------------------------------------------------------
// @}

/** @name Rendering, animation and effect control functions */
	
// @{		  
		//! Stops animation.
		virtual void stop();
		
		//! Starts animation.
		virtual void play();
		
		//! Resets the effect's parameters.
		virtual void reset();

		//! Pauses animation.
		virtual void pause();
		
		//! Je nach Effektauswahl "kein Effekt", "Motion Blur" oder "Bildsubtraktion"
		virtual void render();
// --------------------------------------------------------------------------
// @} 

//! @name Event handlers 
// @{ 
		
		/* Event handlers here are disabled by default and you don't 
		have to reimplement them if base class implementations are 
		sufficient for your needs. Otherwise, uncomment those you
		need and override them in your class. */


		//! Mouse move events handler.
		//virtual void mouseMoveEvent(QMouseEvent*);
		//! Mouse click events handler.
		//virtual void mousePressEvent(QMouseEvent*);
		//! Keyboard events handler.
		//virtual void keyPressEvent(QKeyEvent*);

// --------------------------------------------------------------------------
// @} 


//! @name	Slots:
// @{

	public slots:  
	
	private slots:

		void animate();
// --------------------------------------------------------------------------
// @}


//---------------------------------------------------------------------------
//  Private/Protected Instance Methods
//---------------------------------------------------------------------------

protected:

	//! Initializes effect states and parameters.
	
	AccumEffectPanel* cPan;
	
	virtual void initialize(); 

private:

//---------------------------------------------------------------------------
//  Private/Protected Instance Variables
//---------------------------------------------------------------------------
	
	
	QTimer* effectTimer;
	
	unsigned int Acc_curImg;
	unsigned int Acc_lstLen;

private:

	// Disabled default constructor and assignment operator
	AccumEffect();
	AccumEffect& operator = (const AccumEffect& source);

// --------------------------------------------------------------------------

//@! name Member Variables 
//@{

	GLuint texture; //! Texture object 

	
// --------------------------------------------------------------------------
//@}

//---------------------------------------------------------------------------
//  Class methods and variables
//---------------------------------------------------------------------------

};

#endif

