
/*
    Copyright  2001 Ibragium Kouliev All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef SAMPLEEFFECT2_H
#define SAMPLEEFFECT2_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

//forward references
class QTimer;
class QCheckBox;
class QSlider;
class QLabel;

// local headers
#include "GLEffect.h"

const GLuint checkImageHeight = 64;
const GLuint checkImageWidth = 64;

class SampleEffect2: public GLEffect
{
	Q_OBJECT

	public:

	SampleEffect2(GLFramework* pr);
	virtual ~SampleEffect2();

	//re-implemented control functions
	virtual void stop();
	virtual void play();
	virtual void reset();
	virtual void pause();

	protected:

	virtual void initialize();
	virtual void render();
	


	
	protected:
	void createControls(QWidget* parentWindow);

	protected slots:

	private:

	// helper functions
		void distortVertex(GLfloat& xcoord, GLfloat& ycoord, GLfloat& zcoord,
						  GLint xposition, GLint yposition);
	void initGrid();

	//member vars

	// used to animate effect
	QTimer* effectTimer;

	QCheckBox* zBox;
	QCheckBox* explodeBox;
	QCheckBox* pointBox;
	QCheckBox* lineBox;
	QCheckBox* textureBox;

	QSlider* rateSlider;
	QSlider* distSlider;

	QLabel* fastLabel;
	QLabel* slowLabel;
	
	// optional checkerboard texture 
	GLubyte checkImage[checkImageHeight][checkImageWidth][4];
	
	// current texture
	GLuint texture;

	// vertex /color /tex coord arrays
	GLfloat (*vertexArray)[3];
	GLfloat (*colorArray)[3];
	GLfloat (*texCoordArray)[2];

	GLuint* indexArray;
	
	GLuint gridWidth;
	GLuint gridHeight;

	GLfloat cellSize;

	GLfloat maxDistortionOffset;
	bool zDistort; //distort Z-coord ?
	bool explosionMode; //blow up object?
	bool showPoints; //show grid vertices?
	bool showLines; //show grid lines?
	bool showTexture; //show texture?

	int frameRate;
	
	private slots:

	void animate();
	void setDistortionStrength(int strengh);
	void setZDistortion(bool enable);
	void setFrameRate(int rate);
	void setExplosionMode(bool enable);
	void setTextureMode(bool enable);

	void setPointMode(bool enable);
	void setLineMode(bool enable);
	
};

#endif


