
/*
    Copyright  2001 Ibragium Kouliev All Rights Reserved.
 
 	This file is part of GL Effects Framework.
 
    GL Effects Framework is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GL Effects Framework is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GL Effects Framework; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef SAMPLEEFFECT_H
#define SAMPLEEFFECT_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// local headers
#include "GLEffect.h"

//forward references
class QLabel;
class QSlider;
class QTimer;

class SampleEffect: public GLEffect
{
	Q_OBJECT

	public:

	SampleEffect(GLFramework* pr);
	virtual ~SampleEffect();

	//re-implemented control functions
	virtual void stop();
	virtual void play();
	virtual void reset();
	virtual void pause();


	protected:

	virtual void initialize();
	virtual void render();
	
	//own functions 
	
	protected:
	virtual void createControls(QWidget* parentWindow);
	virtual void wheelEvent(QWheelEvent*);

	void HLS_to_RGB(float *r, float *g, float *b, 
					float h, float l, float s);

	protected slots:
	void animate();


	private:


	
	// effect controls
	QLabel* vertex_label;
	QSlider* vertex_slider;

	QLabel* radius_label;
	QSlider* radius_slider;

	QLabel* inner_radius_label;
	QSlider* inner_radius_slider;

	QLabel* angle_label;
	QSlider* angle_slider;

	// effect parameters
	
	int numVertices;
	float radius;
	float innerRadius;
	GLdouble rotationAngle;
	GLdouble currentAngle;

	float starColor[3];
	float currentHue;


	QTimer* effectTimer;
	
	private slots:

	//these control the effect parameters
	void setNumVertices(int vertices);
	void setRadius(int rad);
	void setInnerRadius(int inr);
	void setAngularVelocity(int ang);

	
};

#endif


