#! @file
#
#  @brief
#  Special include for Linux with glibc 2.x
#
#  This Makefile include is written for use with GNU make and is included
#  on the linux2 platform.
#
#  @author Peter Ellsiepen
#
#  @see getos.sh
#
#  CVSId: "@(#)$Id$"

###############################################################################
# Variables used internally
###############################################################################

### Include directories #######################################################

# STL 
INCDIR_STL		?= 
LIBDIR_STL		?= 

INCDIRS_C			= .

INCDIRS_CXX			= $(INCDIRS_C) \
					  $(INCDIR_STL)

### Library directories #######################################################

LIBDIRS				= . /usr/X11R6/lib

### Disable standard include path #############################################

NOSTDINC_C			=
NOSTDINC_CXX		= #-nostdinc++

### Flags for generating dependencies #########################################

DEPFLAGS_C			= -M
DEPFLAGS_CXX		= -M

### Defines ###################################################################

DEFINES_SOURCE		= -D_GNU_SOURCE #-DGCC #-D_LINUX_SOURCE
DEFINES_SYSTEM		= #-D_REENTRANT -D_THREAD_SAFE #-D_GNU_SOURCE -DLINUX=2.2 
DEFINES_PLATFORM	= #-D_LITTLE_ENDIAN

DEFINES				= $(DEFINES_SOURCE)	\
					  $(DEFINES_SYSTEM)	\
					  $(DEFINES_PLATFORM)

### Warnings ##################################################################

WARNINGS			= -Wall -W -Wpointer-arith -Wcast-qual \
					  -Wcast-align -Wconversion -Woverloaded-virtual \
					  -Wsign-compare -Wnon-virtual-dtor \
					  -Woverloaded-virtual -Wfloat-equal \
					  -Wmissing-prototypes \
					  -Wunreachable-code 
# spaeter wieder anschalten:
# -Wold-style-cast -Wredundant-decls -Wdisabled-optimization
WARNINGS_OFF_CXX	= $(WARNINGS) -Wno-reorder
WARNINGS_OFF_C		= $(WARNINGS_OFF_CXX)
WARNINGS_OFF_LD		=
WARNINGS_OFF_FLEX	:= 
WARNINGS_OFF_BISON	:= 				# additional woffs for bison-generated code
WARNINGS_OFF_DEP	:=              # we don't need warnings while making dep's

### Architecture Flags ########################################################

ISA					?= -march=i686	# i386,i486,pentium,pentiumpro
CPU					?= #-mcpu=pentiumpro		# i386,i486,pentium,pentiumpro

### Compiler-Flags ############################################################

FLAGS_C				= $(ISA) $(CPU) -ansi
FLAGS_CXX			= $(FLAGS_C) \
					  -fno-default-inline -ffor-scope

### Linker-Flags ##############################################################

FLAGS_LD			= $(ISA) $(CPU)

### Shared Object Flags #######################################################

FLAGS_SO_C			= 
FLAGS_SO_CXX		= $(FLAGS_SO_C)
FLAGS_SO_LD			= -shared				# generate shared object

### Debug / Optimize ##########################################################

ifeq ($(DEBUG),$(DEBUG_MARK))
CC_OPTIM			:= -g3 -ggdb3
LD_OPTIM			:= $(CC_OPTIM)
else
CC_OPTIM			:= -O3 \
					  -funroll-loops -fkeep-inline-functions \
					  -felide-constructors \
					  -DNDEBUG
LD_OPTIM			:= $(CC_OPTIM)
# O3 comprises -finline-functions 
# -DNDEBUG switches off the assert() macro
endif

###############################################################################
# Variables used externally
###############################################################################

### These may also be modified externally #####################################

# INCDIRS_C			# instead of CINCLUDEPATH
# INCDIRS_CXX		# instead of CXXINCLUDEPATH
# LIBDIRS			# instead of LDPATH

### Binaries ##################################################################

AR					:= /usr/bin/ar
CXX					:= /usr/bin/g++
#CXX					:= g++3
CC					:= $(CXX)
LD					:= $(CXX)
FLEX				:= $(TOOLSDIR_OS)/bin/flex
BISON				:= $(TOOLSDIR_OS)/bin/bison
LIBDIR_BISON		:= $(TOOLSDIR_OS)/share/
DOXYGEN				:= $(TOOLSDIR_OS)/bin/doxygen
MOC					:= echo# wird in Qt.mak gesetzt
CTAGS				:= ctags

STRIP				:= strip
LNS					:= ln -s
MV					:= mv
RM					:= rm -f
RMR					:= rm -rf
DIFF				:= /usr/bin/diff

### Flags used in targets (see subdir.mak) ####################################

ARFLAGS				:= cr

### Includes / libs used in targets (see subdir.mak) ##########################

CINCLUDEPATH		= $(NOSTDINC_C)   $(addprefix -I,$(INCDIRS_C))
CXXINCLUDEPATH		= $(NOSTDINC_CXX) $(addprefix -I,$(INCDIRS_CXX))

LDPATH				= $(addprefix -L,$(LIBDIRS))
LDLIBS				= $(addprefix -l,$(LIBS))

### ii files ##################################################################

II_FILESDIR			=
