#! @file
#
#  @brief
#  Special include for IRIX 6.5 with gcc compiler
#
#  This Makefile include is written for use with GNU make and is included
#  on the irix65 platform.
#
#  @author Peter Ellsiepen
#
#  @see getos.sh
#
#  CVSId: "@(#)$Id$"

###############################################################################
# Variables used internally
###############################################################################

### Directories to customize ##################################################

ifeq ($(DOMAINNAME),vrcom.de)

EGCS_VERSION		= 2.95.2
EGCS_BASEDIR		= /vrcom/local/gnu/irix65
EGCS_ARCH			= mips-sgi-irix6.5
EGCS_DIR			= $(EGCS_BASEDIR)/lib/gcc-lib/$(EGCS_ARCH)/$(EGCS_VERSION)

BINDIR_EGCS			= $(EGCS_BASEDIR)/bin/

else

$(error directories for irix65 are not yet configured)

endif

### Include directories #######################################################

INCDIR_COMPILER		= $(EGCS_BASEDIR)/$(EGCS_ARCH)/include \
					  $(EGCS_DIR)/include
INCDIR_SYSTEM		= /usr/include
INCDIR_SYSTEM_CXX	= $(EGCS_BASEDIR)/include/g++-3

INCDIRS_C			= .

INCDIRS_CXX			= $(INCDIRS_C) \
					  $(INCDIR_STL) \
  					  $(INCDIR_SYSTEM_CXX)

### Library directories #######################################################

LIBDIRS				= .

### Flags for generating dependencies #########################################

DEPFLAGS_C			= -MM
DEPFLAGS_CXX		= -MM

### Defines ###################################################################

DEFINES_SOURCE		= -D_IRIX_SOURCE -D_GNU_SOURCE
DEFINES_SYSTEM		= -DIRIX=$(shell expr substr `uname -r` 1 1)
DEFINES_PLATFORM	=

DEFINES				= $(DEFINES_SOURCE)	\
					  $(DEFINES_SYSTEM)	\
					  $(DEFINES_PLATFORM)

### Warnings ##################################################################

#WARNINGS			= -Wall					# leads to *MANY* warnings :-(
WARNINGS			=
WARNINGS_OFF_C		=
WARNINGS_OFF_CXX	=
WARNINGS_OFF_LD		= -Wl,-woff,84
WARNINGS_OFF_FLEX	:= 
WARNINGS_OFF_BISON	:= 				# additional woffs for bison-generated code

# Ignored linker warnings:
# LD:
#   84: <lib> is not used for resolving any symbol
#   85: definition of <symbol> in <file> preempts that definition in <lib>
#  127: Two shared objects with the same soname, ... Ignoring the latter.
#  134: weak definition of <symbol> in <file> preempts that
#		weak definition in <lib>

### Architecture Flags ########################################################

ABI					?= -mabi=n32			# -mabi=32, -mabi=n32, -mabi=64
ISA					?= -mips3				# -mips1 .. -mips4
CPU					?= -mcpu=r8000			# r2000, r3000, r4000, r4400,
											# r4600, r4650, r5000, r6000,
											# r8000

### Compiler-Flags ############################################################

FLAGS_C				= $(ABI) $(ISA) $(CPU) \
					  -ansi -use_readonly_const
FLAGS_CXX			= $(FLAGS_C)

### Linker-Flags ##############################################################

FLAGS_LD			= $(ABI) $(ISA) $(CPU)

### Shared Object Flags #######################################################

FLAGS_SO_C			= -fpic					# position independent code
FLAGS_SO_CXX		= $(FLAGS_SO_C)
FLAGS_SO_LD			= -shared				# generate shared object

### Debug / Optimize ##########################################################

ifeq ($(DEBUG),$(DEBUG_MARK))
OPTIM				= -g3
else
OPTIM				= -O2
endif

###############################################################################
# Variables used externally
###############################################################################

### These may also be modified externally #####################################

# INCDIRS_C			# instead of CINCLUDEPATH
# INCDIRS_CXX		# instead of CXXINCLUDEPATH
# LIBDIRS			# instead of LDPATH

### Initialize library names ##################################################

LIBS_PRE			=
LIBS_PROJECT		=
LIBS_POST1			=
LIBS_POST2			=
LIBS_POST3			=
LIBS_POST4			=

LIBS				= $(LIBS_PRE)		\
					  $(LIBS_PROJECT)	\
					  $(LIBS_POST1)		\
					  $(LIBS_POST2)		\
					  $(LIBS_POST3)		\
					  $(LIBS_POST4)

### Binaries ##################################################################

AR					:= /usr/bin/ar
CC					:= $(BINDIR_EGCS)gcc
CXX					:= $(BINDIR_EGCS)g++
LD					:= $(BINDIR_EGCS)g++
FLEX				:= $(TOOLSDIR)/irix65/bin/flex
BISON				:= $(TOOLSDIR)/irix65/bin/bison
LIBDIR_BISON		:= $(TOOLSDIR)/irix65/share/
DOXYGEN				:= $(TOOLSDIR)/irix65/bin/doxygen
MOC					:= echo# wird in Qt.mak gesetzt

STRIP				:= strip
LNS					:= ln -s
MV					:= mv
RM					:= rm -f
RMR					:= rm -rf
DIFF				:= /bin/diff

### Flags used in targets (see subdir.mak) ####################################

ARFLAGS				= cr

CFLAGS				= $(FLAGS_C) $(FLAGS_SO_C) $(OPTIM)		\
					  $(WARNINGS) $(WARNINGS_OFF_C)			\
					  $(DEFINES)

CXXFLAGS			= $(FLAGS_CXX) $(FLAGS_SO_CXX) $(OPTIM)	\
					  $(WARNINGS) $(WARNINGS_OFF_CXX)		\
					  $(DEFINES)

LDFLAGS				= $(FLAGS_LD) $(OPTIM)					\
					  $(WARNINGS) $(WARNINGS_OFF_LD)		\
					  $(DEFINES)

LDSOFLAGS			= $(FLAGS_SO_LD) $(LDFLAGS)

LDSOFLAGS			+= -Wl,"-soname $(SONAMENOPATH)"

### Includes / libs used in targets (see subdir.mak) ##########################

CINCLUDEPATH		= $(NOSTDINC_C)   $(addprefix -I,$(INCDIRS_C))
CXXINCLUDEPATH		= $(NOSTDINC_CXX) $(addprefix -I,$(INCDIRS_CXX))

LDPATH				= $(addprefix -L,$(LIBDIRS))
LDLIBS				= $(addprefix -l,$(LIBS))

### ii files ##################################################################

II_FILESDIR			=
