# ksh under Unix, bash under Cygwin

# Create .mak file for default packages

default_packages="$1"
makdir="$2"
basedir="$3"
objdir="$4"

if [[ -z "$default_packages" || -z "$makdir" ||
	  -z "$basedir" || -z "$objdir" ||
	  $# != 4 ]]
then
	echo >& 2
	echo Usage: Defaultpackages.sh packages .. makdir basedir objdir >& 2
	echo >& 2
	exit 1
fi

for p in $default_packages
do
	p_dir=`find $basedir -type d -name $p -print | head -1`
	if [[ $? != 0 || -z "$p_dir" ]]
	then
		echo >& 2
		echo Defaultpackages.sh: Error: failed to find directory $p! >& 2
		continue
	fi

	if [[ -f $makdir/$p.mak ]]
	then
		echo  >& 2
		echo Defaultpackages.sh: Error: $makdir/$p.mak package makefile exists already! >& 2
		continue
	fi

	echo "# .mak file for package $p" > $makdir/$p.mak
	echo "# automatically generated by Defaultpackages.sh" >> $makdir/$p.mak
	echo "# do NOT check in!" >> $makdir/$p.mak
	echo "" >> $makdir/$p.mak
	echo "INCDIRS_CXX   += $p_dir" >> $makdir/$p.mak
	echo "LIBDIRS       += $p_dir/$objdir" >> $makdir/$p.mak
	echo "LIBS_PROJECT  += $p" >> $makdir/$p.mak

	if [[ -f $makdir/$p.req ]]
	then
		echo "" >> $makdir/$p.mak
		echo "include $makdir/$p.req" >> $makdir/$p.mak
	fi

	if [[ ! -s $makdir/.cvsignore ]]
	then
		chmod u+w $makdir
		echo $p.mak > $makdir/.cvsignore
	elif grep -q $p $makdir/.cvsignore
	then
		true
	else
		chmod u+w $makdir/.cvsignore
		echo " $p.mak" >> $makdir/.cvsignore
	fi

done

# CVSId: "@(#)$Id$"
